<?php
/*
 * Plugin Name:       Tax Exempt for WooCommerce
 * Plugin URI:        https://woocommerce.com/products/woocommerce-tax-exempt-plugin/
 * Description:       WooCommerce Tax Exempt plugin allows merchants to tax-exempt selected customers and user roles.
 * Version:           1.7.0
 * Author:            Addify
 * Developed By:      Addify
 * Author URI:        https://woocommerce.com/vendor/addify/
 * Support:           https://woocommerce.com/vendor/addify/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Domain Path:       /languages
 * Text Domain:       addify_tax_exempt
 *
 * Woo: 4721661:1640a61aff7cf4fdc566b66103bdb843
 * WC requires at least: 3.0.9
 * WC tested up to: 8.*.*
 *
 */
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

	if ( ! defined( 'WC_PLUGIN_FILE' ) ) {
		define( 'WC_PLUGIN_FILE', plugin_dir_url( __FILE__ ) );
	}

	function afrbp_admin_notice() {

		$afrbp_allowed_tags = array(
			'a'      => array(
				'class' => array(),
				'href'  => array(),
				'rel'   => array(),
				'title' => array(),
			),
			'b'      => array(),

			'div'    => array(
				'class' => array(),
				'title' => array(),
				'style' => array(),
			),
			'p'      => array(
				'class' => array(),
			),
			'strong' => array(),

		);

		// Deactivate the plugin
		deactivate_plugins( __FILE__ );

		$afrbp_woo_check = '<div id="message" class="error">
			<p><strong>Tax Exempt for WooCommerce is inactive.</strong> The <a href="http://wordpress.org/extend/plugins/woocommerce/">WooCommerce plugin</a> must be active for this plugin to work. Please install &amp; activate WooCommerce »</p></div>';
		echo wp_kses( __( $afrbp_woo_check, 'addify_tax_exempt' ), $afrbp_allowed_tags );

	}

	add_action( 'admin_notices', 'afrbp_admin_notice' );
}

if ( ! class_exists( 'Addify_Tax_Exempt' ) ) {

	class Addify_Tax_Exempt {

		public function __construct() {

			$this->aftax_global_constents_vars();
			$this->set_media_path_url();
			add_action( 'wp_loaded', array( $this, 'aftax_init' ) );

			register_activation_hook( __FILE__, array( $this, 'aftax_installation' ) );

			if ( is_admin() ) {
				include_once AFTAX_PLUGIN_DIR . 'class_aftax_admin.php';
			} else {
				include_once AFTAX_PLUGIN_DIR . 'class-aftax-front.php';
			}

			add_filter( 'woocommerce_email_classes', array( $this, 'aftax_emails' ), 90, 1 ); 

			//HOPS compatibility
			add_action('before_woocommerce_init', array($this, 'aftax_HOPS_Compatibility'));

			//Define a cron job interval if it doesn't exist
			add_filter( 'cron_schedules', array($this, 'aftax_cron_for_expire_info' ));
			//Schedule an event unless already scheduled
			add_action( 'wp', array($this, 'aftax_new_cron_job' ));
			//Trigger cron hook
			add_action( 'aftax_send_expire_info_email', array($this, 'aftax_send_expire_info_email_callback' ));
		}

		public function aftax_HOPS_Compatibility() {

			if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			}
		}

		public function aftax_cron_for_expire_info( $schedules) {

			$schedules['every_one_minute'] = array(
				'interval' => 60,
				'display'  => __( 'Every 1 minute' ),
			);
			return $schedules;

		}

		public function aftax_new_cron_job() {

			if ( ! wp_next_scheduled( 'aftax_send_expire_info_email' ) ) {
			  wp_schedule_event( time(), 'every_one_minute', 'aftax_send_expire_info_email' );
			}
		}

		public function aftax_send_expire_info_email_callback() {

			wc()->mailer();

			$users = get_users(array(
				'meta_key'     => 'aftax_tax_expire_date',
				'meta_value'   => '',
				'meta_compare' => '!=',
			));

			foreach ($users as $s_user) {

				$user_id                    = $s_user->ID;
				$user_info                  = get_userdata( $user_id );
				$aftax_text_field           = $user_info->aftax_text_field;
				$aftax_textarea_field       = $user_info->aftax_textarea_field;
				$aftax_fileupload_field     = $user_info->aftax_fileupload_field;
				$aftax_tax_exemption_status = $user_info->aftax_tax_exemption_status;
				$aftax_tax_expire_date      = $user_info->aftax_tax_expire_date;


				$current_date = gmdate( 'Y-m-d' );

				if ( ! empty( $aftax_tax_expire_date ) ) {

					$exp_date = $aftax_tax_expire_date;
				} else {

					$exp_date = '';
				}

				if ('' != $exp_date && $current_date > $exp_date) {

					update_metadata( 'user', $user_id, 'aftax_tax_exemption_status', 'expired', '' );
				}

				$aftax_is_expire_sent_email = $user_info->aftax_tax_info_expire_email;


				if ('sent' !==  $aftax_is_expire_sent_email && 'expired' === $aftax_tax_exemption_status) {
					//Email to admin
					do_action( 'aftax_expire_info_notification_admin', $user_id, $aftax_text_field, $aftax_textarea_field, $aftax_fileupload_field);

					//Email to user
					do_action( 'aftax_expire_info_notification_user', $user_id, $aftax_text_field, $aftax_textarea_field, $aftax_fileupload_field);

					update_metadata( 'user', $user_id, 'aftax_tax_info_expire_email', 'sent', '' );
				}
			}
		}

		private function set_media_path_url() {

			$upload_dir = wp_upload_dir();

			$upload_path = $upload_dir['basedir'] . '/addify-tax-exempt/';

			if ( !is_dir( $upload_path ) ) {
				mkdir( $upload_path );
			}

			$upload_url = $upload_dir['baseurl'] . '/addify-tax-exempt/';

			if ( ! defined( 'AFTAX_MEDIA_URL' ) ) {
				define( 'AFTAX_MEDIA_URL', $upload_url);
			}

			if ( ! defined( 'AFTAX_MEDIA_PATH' ) ) {
				define( 'AFTAX_MEDIA_PATH', $upload_path);
			}
		}

		public function aftax_installation() {

			update_option('af_tax_flush_rules', 'yes' );

			//Default Email subject and messages
			//Tax information submission message to admin
			if (empty(get_option('aftax_admin_email_message'))) {

				$info_msg_admin = '
				<p>{user_name} have submitted tax exemption form with the following details.</p>
				<p>{form_data}</p>
				<p>Approve Exemption Request:<br />
				{approve_link}
				</p>
				<p>Disapprove Exemption Request:<br />
				{disapprove_link}
				</p>
				';
				update_option('aftax_admin_email_message', $info_msg_admin);

			}

			if (empty(get_option('aftax_customer_email_message'))) {

				$info_msg_user = '
				<p>Hi {user_name},</p>
				<p>Thank you for submitted the tax exemption form. We have received your tax exemption request with the following details,</p>
				<p>{form_data}</p>
				
				';
				update_option('aftax_customer_email_message', $info_msg_user);

			}

			if (empty(get_option('aftax_admin_approve_tax_info_email_message'))) {

				$info_approve_msg_admin = '
				<p>The tax exemption has been approved for the following user,</p>
				<p>
				{user_name}<br />
				{customer_email}<br />
				{form_data}
				</p>
				
				';
				update_option('aftax_admin_approve_tax_info_email_message', $info_approve_msg_admin);

			}

			if (empty(get_option('aftax_approve_tax_info_email_message'))) {

				$info_approve_msg_user = '
				<p>Hi {user_name},</p>
				<p>Your tax exemption request has been approved. Below are the details of your tax exemption request,</p>
				<p>{form_data}</p>
				
				';
				update_option('aftax_approve_tax_info_email_message', $info_approve_msg_user);

			}

			if (empty(get_option('aftax_disapprove_tax_info_email_message'))) {

				$info_disapprove_msg_user = '
				<p>Hi {user_name},</p>
				<p>We regret to inform you that your tax exemption request has been declined. Below are the are details of your tax exemption request. If you feel this is mistake, please feel free to reach out to us.</p>
				<p>{form_data}</p>
				
				';
				update_option('aftax_disapprove_tax_info_email_message', $info_disapprove_msg_user);

			}

			if (empty(get_option('aftax_expire_tax_info_email_message'))) {

				$info_expire_msg_admin = '
				<p>Tax exemption has expired for {user_name}. Below are the details of the users tax exemption form,</p>
				<p>{form_data}</p>
				
				';
				update_option('aftax_expire_tax_info_email_message', $info_expire_msg_admin);

			}

			if (empty(get_option('aftax_customer_expire_tax_info_email_message'))) {

				$info_expire_msg_user = '
				<p>Hi {user_name},</p>
				<p>Your tax exemption has expired. Please provide the upload the updated tax exemption details from My Account > Tax Exemption. Below are the details of your existing tax exemption request. If you believe it’s a mistake, please reach out to us.</p>
				<p>{form_data}</p>
				
				';
				update_option('aftax_customer_expire_tax_info_email_message', $info_expire_msg_user);

			}

		}

		public function aftax_global_constents_vars() {

			if ( ! defined( 'AFTAX_URL' ) ) {
				define( 'AFTAX_URL', plugin_dir_url( __FILE__ ) );
			}

			if ( ! defined( 'AFTAX_BASENAME' ) ) {
				define( 'AFTAX_BASENAME', plugin_basename( __FILE__ ) );
			}

			if ( ! defined( 'AFTAX_PLUGIN_DIR' ) ) {
				define( 'AFTAX_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
			}
		}

		public function aftax_init() {

			if ( function_exists( 'load_plugin_textdomain' ) ) {
				load_plugin_textdomain( 'addify_tax_exempt', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
			}
		}

		public function aftax_emails( $emails) {

			require_once AFTAX_PLUGIN_DIR . 'classes/aftax-info-admin-email-class.php';
			$emails['aftax_info_admin_email'] = new  Addify_Tax_Info_Admin_Email();

			require_once AFTAX_PLUGIN_DIR . 'classes/aftax-info-user-email-class.php';
			$emails['aftax_info_user_email'] = new  Addify_Tax_Info_User_Email();

			require_once AFTAX_PLUGIN_DIR . 'classes/aftax-approve-info-admin-email-class.php';
			$emails['aftax_approve_info_admin_email'] = new  Addify_Tax_Approve_Info_Admin_Email();

			require_once AFTAX_PLUGIN_DIR . 'classes/aftax-approve-info-user-email-class.php';
			$emails['aftax_approve_info_user_email'] = new  Addify_Tax_Approve_Info_User_Email();

			require_once AFTAX_PLUGIN_DIR . 'classes/aftax-disapprove-info-email-class.php';
			$emails['aftax_disapprove_info_email'] = new  Addify_Tax_Disapprove_Info_Email();

			require_once AFTAX_PLUGIN_DIR . 'classes/aftax-expire-info-admin-email-class.php';
			$emails['aftax_expire_info_admin_email'] = new  Addify_Tax_Expire_Info_Admin_Email();

			require_once AFTAX_PLUGIN_DIR . 'classes/aftax-expire-info-user-email-class.php';
			$emails['aftax_expire_info_user_email'] = new  Addify_Tax_Expire_Info_User_Email();
			

			
			

			return $emails;
		}
	}

	new Addify_Tax_Exempt();

}
