<?php

/**
 * Tax Exemption request settings
 */

add_settings_section(
	'aftax-request-sec',         // ID used to identify this section and with which to register options.
	esc_html__( 'Tax Exemption Request Settings', 'addify_tax_exempt' ),   // Title to be displayed on the administration page.
	'aftax_request_sec_callback', // Callback used to render the description of the section.
	'aftax_request_setting_section' // Page on which to add this section of options.
);

//User Roles
add_settings_field(
	'aftax_requested_roles[]',                      // ID used to identify the field throughout the theme.
	esc_html__( 'Select User Roles', 'addify_tax_exempt' ),    // The label to the left of the option interface element.
	'aftax_requested_roles_callback',   // The name of the function responsible for rendering the option interface.
	'aftax_request_setting_section',   // The page on which this option will be displayed.
	'aftax-request-sec',         // The name of the section to which this field belongs.
	array( 
		'description' => esc_html__( 'Choose user roles to allow them to request for tax exemption.', 'addify_tax_exempt' )
		)
);

register_setting(
	'aftax_request_setting_fields',
	'aftax_requested_roles'
);

//Auto approval tax exemption request
add_settings_field(
	'aftax_enable_auto_tax_exempt',                      // ID used to identify the field throughout the theme.
	esc_html__( 'Auto Approve Tax Exempt Request', 'addify_tax_exempt' ),    // The label to the left of the option interface element.
	'aftax_enable_auto_tax_exempt_callback',   // The name of the function responsible for rendering the option interface.
	'aftax_request_setting_section',   // The page on which this option will be displayed.
	'aftax-request-sec',         // The name of the section to which this field belongs.
	array( 
		'description' => esc_html__( 'If this option is checked then tax exempt requests will be auto-approved and users of above selected user roles will be eligible for tax exempt right after submitting the info.', 'addify_tax_exempt' )
		)
);

register_setting(
	'aftax_request_setting_fields',
	'aftax_enable_auto_tax_exempt'
);


//Enable tax exemption message on checkout page
add_settings_field(
	'aftax_enable_tax_exm_msg',                      // ID used to identify the field throughout the theme.
	esc_html__( 'Show Tax Exemption Message on Checkout Page', 'addify_tax_exempt' ),    // The label to the left of the option interface element.
	'aftax_enable_tax_exm_msg_callback',   // The name of the function responsible for rendering the option interface.
	'aftax_request_setting_section',   // The page on which this option will be displayed.
	'aftax-request-sec',         // The name of the section to which this field belongs.
	array( 
		'description' => esc_html__( 'If this option is checked then a message will be displayed for the above selected user role users about tax exemption.', 'addify_tax_exempt' ) 
	)
);

register_setting(
	'aftax_request_setting_fields',
	'aftax_enable_tax_exm_msg'
);


//Message text
add_settings_field(
	'aftax_role_message_text',                      // ID used to identify the field throughout the theme.
	esc_html__( 'Message Text', 'addify_tax_exempt' ),    // The label to the left of the option interface element.
	'aftax_role_message_text_callback',   // The name of the function responsible for rendering the option interface.
	'aftax_request_setting_section',   // The page on which this option will be displayed.
	'aftax-request-sec',         // The name of the section to which this field belongs.
	array( 
		'description' => esc_html__( 'This will be visible for the user roles customer has selected above.', 'addify_tax_exempt' ),
		'label_for'    => 'aftax_role_message_text',
		'tip' => 'dfasfdsfdsfdsfdsfdsfdsfdsfdsfdsfdsfdsf',
		'class' => 'aftax_role_message_text_div'
		)
);

register_setting(
	'aftax_request_setting_fields',
	'aftax_role_message_text'
);






/**
 * Heading of Tax Exemption request
 */
function aftax_request_sec_callback() {    ?>
	<p><?php esc_html_e( 'Select user roles for whom you want to display tax exemption form in "My Account" page and a checkbox in the checkout page to notify them that tax exemption is available.', 'addify_tax_exempt' ); ?></p>
	<?php
}


function aftax_requested_roles_callback( $args) {

	?>

	<div class="all_cats">
		<ul>

		<?php
		$aftax_requested_roles = (array) maybe_unserialize( get_option( 'aftax_requested_roles' ) );
		global $wp_roles;
		$roles = $wp_roles->get_names();
		foreach ( $roles as $key => $value ) {
			?>

			<li class="par_cat">
				<input type="checkbox" class="parent" name="aftax_requested_roles[]" id="aftax_requested_roles" value="<?php echo esc_attr( $key ); ?>" 
			<?php
			if ( ! empty( $aftax_requested_roles ) && in_array( $key, $aftax_requested_roles ) ) {
				echo 'checked';
			}
			?>
			/>
			<?php echo esc_attr( $value ); ?>
			</li>

		<?php } ?>
			<li class="par_cat">
				<input type="checkbox" class="parent" name="aftax_requested_roles[]" id="aftax_requested_roles_guest" value="guest" 
				<?php
				if ( ! empty( $aftax_requested_roles ) && in_array( 'guest', $aftax_requested_roles ) ) {
					echo 'checked';
				}
				?>
				/>
				<?php echo esc_attr( 'Guest' ); ?>
			</li>

			</ul>
		</div>
	
	
	<p class="aftax_des"><?php echo wp_kses_post( $args['description'] ); ?></p>
	<?php
}

function aftax_enable_auto_tax_exempt_callback( $args) {

	?>

	
	<input type="checkbox" name="aftax_enable_auto_tax_exempt" id="aftax_enable_auto_tax_exempt" value="yes" <?php echo checked( 'yes', esc_attr( get_option( 'aftax_enable_auto_tax_exempt' ) ) ); ?> />
	<p class="aftax_des"><?php echo wp_kses_post( $args['description'] ); ?></p>
	<?php
}


function aftax_enable_tax_exm_msg_callback( $args) {

	?>

	
	<input type="checkbox" name="aftax_enable_tax_exm_msg" id="aftax_enable_tax_exm_msg" value="yes" <?php echo checked( 'yes', esc_attr( get_option( 'aftax_enable_tax_exm_msg' ) ) ); ?> />
	<p class="aftax_des"><?php echo wp_kses_post( $args['description'] ); ?></p>
	<?php
}

function aftax_role_message_text_callback( $args) {

	?>
		<?php

			$content   = get_option( 'aftax_role_message_text' );
			$content   =wpautop( wptexturize(stripslashes($content)) );
			$editor_id = 'aftax_role_message_text';
			$settings  = array( 'textarea_name' => 'aftax_role_message_text' );

			wp_editor( $content, $editor_id, $settings );

		?>

	<p class="aftax_des"><?php echo wp_kses_post( $args['description'] ); ?></p>
	<?php
}




