<?php
use Automattic\WooCommerce\Blocks\Integrations\IntegrationInterface;

	/**
	* Class for integrating with WooCommerce Blocks
	*/
class Addify_Blocks_Integration implements IntegrationInterface {

	/**
	 * The name of the integration.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'af_vat_tax_exempt_block';
	}

	/**
	 * When called invokes any initialization/setup for the integration.
	 */
	public function initialize() {
	
		add_action( 'wp_head', array( $this, 'aftax_set_auto_tax_exemption' ));
		$this->register_AF_Tax_Exempt_block__block_frontend_scripts();
		$this->register_AF_Tax_Exempt_block__block_editor_scripts();
		$this->register_main_integration();
		add_action( 'wp_enqueue_scripts', array( $this, 'aftax_front_script' )  );
		add_action( 'wp_ajax_set_tax_exempt_val', array( $this, 'set_tax_exempt_val' )  );
	}

	public function aftax_set_auto_tax_exemption() {

   
		global $woocommerce;
	
		if ( 'yes' === get_option( 'aftax_enable_auto_tax_exempttion' ) ) {
		
			if ( is_user_logged_in() ) {
	
				$user                      = wp_get_current_user();
				$user_info                 = get_userdata( $user->ID );
				$role                      = (array) $user->roles;
				$afuserroles               = (array) maybe_unserialize( get_option( 'aftax_requested_roles' ) );
				$afcustomers               = (array) maybe_unserialize( get_option( 'aftax_exempted_customers' ) );
				$aftax_exempted_user_roles = (array) maybe_unserialize( get_option( 'aftax_exempted_user_roles' ) );
				if ( ! empty( $afcustomers ) ) {
					$exm_customers = $afcustomers;
				} else {
					$exm_customers = array();
				}
	
				if ( ! empty( $aftax_exempted_user_roles ) ) {
					$exm_roles = $aftax_exempted_user_roles;
				} else {
					$exm_roles = array();
				}
	
				$aftax_tax_expire_date = get_user_meta( $user->ID , 'aftax_tax_expire_date' , true );
				$current_date          = gmdate( 'Y-m-d' );
	
				if ( ! empty( $aftax_tax_expire_date ) ) {
	
					$exp_date = $aftax_tax_expire_date;
				} else {
	
					$exp_date = '';
				}
	
				$aftax_tax_exemption_status = get_user_meta( $user->ID , 'aftax_tax_exemption_status' , true );
	
				if ( 'approved' == $aftax_tax_exemption_status ) {
	
					if ( $current_date <= $exp_date ) {
						$woocommerce->customer->set_is_vat_exempt( true );
	
					} elseif ( empty( $aftax_tax_expire_date ) ) {
						$woocommerce->customer->set_is_vat_exempt( true );
	
					}
	
				} elseif ( in_array( $user->ID, $exm_customers ) || in_array( $role[0], $exm_roles ) ) {
	
					$woocommerce->customer->set_is_vat_exempt( true );
	
				} else {
	
					$woocommerce->customer->set_is_vat_exempt( false );
				}
			} else {
				$aftax_exempted_user_roles = (array) maybe_unserialize( get_option( 'aftax_exempted_user_roles' ) );
	
				if ( ! empty( $aftax_exempted_user_roles ) ) {
					$exm_roles = $aftax_exempted_user_roles;
				} else {
					$exm_roles = array();
				}
				if ( in_array( 'guest', $exm_roles ) ) {
	
					$woocommerce->customer->set_is_vat_exempt( true );
	
				}
			}
			
		} else {
			$woocommerce->customer->set_is_vat_exempt( false );
		}
	}

	public function set_tax_exempt_val() {

		$af_tax_checkbox_is_checked = isset( $_POST['af_tax_checkbox_is_checked'] ) && '' !== $_POST['af_tax_checkbox_is_checked'] ? sanitize_text_field( wp_unslash( $_POST['af_tax_checkbox_is_checked'] ) ) : 0;
		$nonce                      = isset( $_POST['nonce'] ) && '' !== $_POST['nonce'] ? sanitize_text_field( wp_unslash( $_POST['nonce'] ) ) : 0;

		if ( empty( $_POST['nonce'] ) || ! wp_verify_nonce( $nonce, 'aftax-blocks-ajax-nonce' ) ) {
			die( esc_html__( 'Failed ajax security check!', 'addify_tax_exempt' ) );
		}

		$woocommerce = WC();

		if (( isset($woocommerce) )&&( !empty($woocommerce) )) {


			if (( 'checked'==$af_tax_checkbox_is_checked )) {
	 
				$woocommerce->customer->set_is_vat_exempt( true );
			 
				 
			} else { 
			 
				$woocommerce->customer->set_is_vat_exempt( false );
			 
			}

			$response = array(
				'decimals'     => wc_get_price_decimals(),
				'price_format' => get_woocommerce_price_format(),
			);
			
			wp_send_json_success( $response );

		}
	}

	public function aftax_front_script() {
		$aftax_checkbox_display = 'no';

		$aftax_is_guest_user_message_to_display ='no';

		$aftax_is_message_to_display_for_user_roles ='no';
	
		if ( is_user_logged_in() ) {
	
			$user                      = wp_get_current_user();
			$user_info                 = get_userdata( $user->ID );
			$role                      = (array) $user->roles;
			$afuserroles               = (array) maybe_unserialize( get_option( 'aftax_requested_roles' ) );
			$afcustomers               = (array) maybe_unserialize( get_option( 'aftax_exempted_customers' ) );
			$aftax_exempted_user_roles = (array) maybe_unserialize( get_option( 'aftax_exempted_user_roles' ) );
			if ( ! empty( $afcustomers ) ) {
				$exm_customers = $afcustomers;
			} else {
				$exm_customers = array();
			}
	
			if ( ! empty( $aftax_exempted_user_roles ) ) {
				$exm_roles = $aftax_exempted_user_roles;
			} else {
				$exm_roles = array();
			}
			$aftax_tax_expire_date = get_user_meta( $user->ID , 'aftax_tax_expire_date' , true );
			$current_date          = gmdate( 'Y-m-d' );
	
			if ( ! empty( $aftax_tax_expire_date ) ) {
	
				$exp_date = $aftax_tax_expire_date;
			} else {
	
				$exp_date = '';
			}
	
			$aftax_tax_exemption_status = get_user_meta( $user->ID , 'aftax_tax_exemption_status' , true );
	
			$aftax_checkbox_display = 'no';
			$aftax_checkbox_status  = false;
			$aftax_message_status   = false;
	
			if ( 'yes' == esc_attr( get_option( 'aftax_enable_tax_exm_msg' ) ) && in_array( $role[0], $afuserroles ) ) {
				if ( ! ( in_array( $role[0], $exm_roles ) || in_array( $user->ID, $exm_customers  ) || 'approved' == $aftax_tax_exemption_status ) ) {
					$aftax_message_status = true;
				}
			}
	
			if ( 'yes' != get_option( 'aftax_enable_auto_tax_exempttion' ) ) {
				if ( in_array( $role[0], $exm_roles ) || in_array( $user->ID, $exm_customers ) || 'approved' == $aftax_tax_exemption_status ) {
	
					$aftax_checkbox_display ='yes';
					$aftax_checkbox_status  = true;
				}
			}
	
			if ( $aftax_checkbox_status ) {
	
				$aftax_is_guest_user_message_to_display ='no';
	
				$aftax_is_message_to_display_for_user_roles ='no';
	
			} elseif ( $aftax_message_status ) {
				
				$aftax_is_guest_user_message_to_display ='no';
	
				$aftax_is_message_to_display_for_user_roles ='yes';
			}
		} elseif ( 'yes' != get_option( 'aftax_enable_auto_tax_exempttion' ) ) {
				$aftax_exempted_user_roles = (array) maybe_unserialize( get_option( 'aftax_exempted_user_roles' ) );
			if ( in_array( 'guest', $aftax_exempted_user_roles ) ) {
				 
				$aftax_is_guest_user_message_to_display ='no';
	
				$aftax_is_message_to_display_for_user_roles ='no';
					
			} elseif ( 'yes' == esc_attr( get_option( 'aftax_enable_guest_message' ) ) ) { 
	
				$aftax_is_guest_user_message_to_display ='yes';
	
				$aftax_is_message_to_display_for_user_roles ='no';
			}
	
		} elseif ( 'yes' == esc_attr( get_option( 'aftax_enable_guest_message' ) ) ) { 
			$aftax_exempted_user_roles = (array) maybe_unserialize( get_option( 'aftax_exempted_user_roles' ) );
			if ( in_array( 'guest', (array) $aftax_exempted_user_roles ) ) {
				return;
			}
			$aftax_is_guest_user_message_to_display ='yes';
	
			$aftax_is_message_to_display_for_user_roles ='no';
		}
		
		wp_enqueue_script( 'aftax-blocks-frontj', plugins_url( '/src/js/af-tax-exempt-block/block.js', __FILE__ ), '', '1.0', false  );
		wp_enqueue_script( 'jquery' );
		$af_tax_block_data = array(
			'aftax_translation_tax_exempt_notification'  => __('Tax Exempted', 'addify_tax_exempt'),
			'aftax_translation_tax_exempt_heading'       => __('Tax Exemption', 'addify_tax_exempt'),
			'aftax_translation_tax_exempt_message'       => __('Do you want to include tax exemption?', 'addify_tax_exempt'),
			'admin_url'                                  => admin_url( 'admin-ajax.php' ),
			'nonce'                                      => wp_create_nonce( 'aftax-blocks-ajax-nonce' ),
			'aftax_is_message_to_display_for_user_roles' => $aftax_is_message_to_display_for_user_roles,
			'aftax_guest_message_show'                   =>get_option( 'aftax_guest_message_text' ),
			'aftax_is_guest_user_message_to_display'     => $aftax_is_guest_user_message_to_display,
			'aftax_user_roles_message_show'              =>get_option( 'aftax_role_message_text' ),
			'aftax_checkbox_display'                     =>$aftax_checkbox_display,
			'aftax_enable_auto_tax_exempttion'           =>get_option( 'aftax_enable_auto_tax_exempttion' ),
		);
		
		wp_localize_script( 'aftax-blocks-frontj', 'aftax_php_vars', $af_tax_block_data );
	}

	/**
	 * Registers the main JS file required to add filters and Slot/Fills.
	 */
	public function register_main_integration() {
		$script_path       = '/build/index.js';
		$script_url        = plugins_url( $script_path, __FILE__ );
		$script_asset_path = __DIR__ . '/build/index.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require $script_asset_path
			: array(
				'dependencies' => array(),
				'version'      => $this->get_file_version( $script_path ),
			);

		wp_register_script(
			'af-tax-exempt-blocks-integration',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);
		wp_set_script_translations(
			'af-tax-exempt-blocks-integration',
			'af_vat_tax_exempt_block',
			__DIR__ . '/languages'
		);
	}

	/**
	 * Returns an array of script handles to enqueue in the frontend context.
	 *
	 * @return string[]
	 */
	public function get_script_handles() {
		return array( 'af-tax-exempt-blocks-integration', 'af-tax-exempt-block-frontend' );
	}

	/**
	 * Returns an array of script handles to enqueue in the editor context.
	 *
	 * @return string[]
	 */
	public function get_editor_script_handles() {
		return array( 'af-tax-exempt-blocks-integration', 'af-tax-exempt-block-editor' );
	}

	/**
	 * An array of key, value pairs of data made available to the block on the client side.
	 *
	 * @return array
	 */
	public function get_script_data() {
		$data = array(
			'af_vat_tax_exempt_block-active' => true,
			'defaultLabelText'               => __( 'default custom feild heading', 'af_vat_tax_exempt_block' ),
		);

		return $data;
	}

	

	public function register_AF_Tax_Exempt_block__block_editor_scripts() {
		$script_path       = '/build/af-tax-exempt-block.js';
		$script_url        = plugins_url( $script_path, __FILE__ );
		$script_asset_path = __DIR__ . '/build/af-tax-exempt-block.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require $script_asset_path
			: array(
				'dependencies' => array(),
				'version'      => $this->get_file_version( $script_asset_path ),
			);

		wp_register_script(
			'af-tax-exempt-block-editor',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		wp_set_script_translations(
			'af-tax-exempt-block-editor',
			'af_vat_tax_exempt_block',
			__DIR__ . '/languages'
		);
	}

	public function register_AF_Tax_Exempt_block__block_frontend_scripts() {
		$script_path       = '/build/af-tax-exempt-block-frontend.js';
		$script_url        = plugins_url( $script_path, __FILE__ );
		$script_asset_path = __DIR__ . '/build/af-tax-exempt-block-frontend.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require $script_asset_path
			: array(
				'dependencies' => array(),
				'version'      => $this->get_file_version( $script_asset_path ),
			);

		wp_register_script(
			'af-tax-exempt-block-frontend',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);
		wp_set_script_translations(
			'af-tax-exempt-block-frontend',
			'af_vat_tax_exempt_block',
			__DIR__ . '/languages'
		);
	}

	/**
	 * Get the file modified time as a cache buster if we're in dev mode.
	 *
	 * @param string $file Local path to the file.
	 * @return string The cache buster value to use for the given file.
	 */
	protected function get_file_version( $file ) {
		if ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG && file_exists( $file ) ) {
			return filemtime( $file );
		}
		return AF_TAX_BLOCK_VERSION;
	}
}
