/**
 * External dependencies
 */
import { useEffect, useState } from '@wordpress/element';
import { __ } from '@wordpress/i18n';
import apiFetch from '@wordpress/api-fetch';

export const Block = ({ checkoutExtensionData, extensions }) => {
	const aftax_is_message_to_display_for_user_roles =
		aftax_php_vars.aftax_is_message_to_display_for_user_roles;


	const aftax_exempt_heading=aftax_php_vars.aftax_exempt_heading;


	const aftax_guest_message_show = aftax_php_vars.aftax_guest_message_show;

	const aftax_is_guest_user_message_to_display =
		aftax_php_vars.aftax_is_guest_user_message_to_display;

	const aftax_user_roles_message_show =
		aftax_php_vars.aftax_user_roles_message_show;

	const aftax_checkbox_display = aftax_php_vars.aftax_checkbox_display;

	const aftax_translation_tax_exempt_message=aftax_php_vars.aftax_translation_tax_exempt_message;

	const aftax_translation_tax_exempt_heading=aftax_php_vars.aftax_translation_tax_exempt_heading;
	const aftax_translation_tax_exempt_notification=aftax_php_vars.aftax_translation_tax_exempt_notification;
	jQuery(document).ready(function () {
		if (
			aftax_is_message_to_display_for_user_roles == 'yes' &&
			aftax_is_guest_user_message_to_display == 'no'
		) {
			jQuery('.taxExemptInnerDiv').html(
				'<div class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox wc-block-components-checkout-step__container">' +
					aftax_user_roles_message_show +
					'</div>'
			);
		} else if (
			aftax_is_message_to_display_for_user_roles == 'no' &&
			aftax_is_guest_user_message_to_display == 'yes'
		) {
			jQuery('.taxExemptInnerDiv').html(
				'<div class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox wc-block-components-checkout-step__container">' +
					aftax_guest_message_show +
					'</div>'
			);
		}

		jQuery(document).on('DOMNodeInserted', function (e) {
	//		if (jQuery(e.target).is( 'div.wc-block-error')) {
//				if (jQuery('#tax_exemption_checkbox').is(':checked')) {
					jQuery('div.wc-block-error').remove();
//				}[woocommerce_checkout]
		//	}
		});


		console.log(aftax_exempt_heading);

		setTimeout(function () {
			jQuery('.wp-block-af_vat_tax_exempt_block-tax-exempt').show();
			jQuery('.wp-block-af_vat_tax_exempt_block-tax-exempt').insertAfter(
				'.wp-block-woocommerce-checkout-order-note-block'
			);
		}, 2000);
	});

	const { setExtensionData } = checkoutExtensionData;

	const [taxExemptCheckboxIsChecked, setTaxExemptCheckboxIsChecked] =
		useState(false);

	const handleCheckboxChange = (event) => {
		const isChecked = event.target.checked;
		setTaxExemptCheckboxIsChecked(isChecked);

		const stringValue = isChecked ? 'checked' : 'not checked';

		jQuery.ajax({
			type: 'POST',
			url: aftax_php_vars.admin_url,
			data: {
				action: 'set_tax_exempt_val',
				af_tax_checkbox_is_checked: stringValue,
				nonce: aftax_php_vars.nonce,
			},
			success: function (response) {
				if (response.success) {
					jQuery('.wc-block-components-totals-footer-item')
						.find('span.wc-block-components-totals-item__value')
						.each(function () {
							apiFetch({ path: '/wc/store/v1/cart' }).then(
								(posts) => {
									if (response.data.decimals > 0) {
										var newValue =
											posts.totals.total_price.slice(
												0,
												-response.data.decimals
											) +
											posts.totals
												.currency_decimal_separator +
											posts.totals.total_price.slice(
												-response.data.decimals
											);

										var thousandSepratedVal =
											addCustomSeparator(
												newValue,
												posts.totals
													.currency_thousand_separator
											);

										if (
											response.data.price_format ==
											'%1$s&nbsp;%2$s'
										) {
											console.log('Left with space ');
											jQuery(this).text(
												posts.totals.currency_symbol +
													' ' +
													thousandSepratedVal
											);
										} else if (
											response.data.price_format ==
											'%2$s&nbsp;%1$s'
										) {
											console.log('Right with space');
											jQuery(this).text(
												thousandSepratedVal +
													' ' +
													posts.totals.currency_symbol
											);
										} else if (
											response.data.price_format ==
											'%1$s%2$s'
										) {
											console.log('Left');
											jQuery(this).text(
												posts.totals.currency_symbol +
													'' +
													thousandSepratedVal
											);
										} else if (
											response.data.price_format ==
											'%2$s%1$s'
										) {
											console.log('Right');
											jQuery(this).text(
												thousandSepratedVal +
													'' +
													posts.totals.currency_symbol
											);
										}
									} else {
										var thousandSepratedVal =
											addCustomSeparator(
												posts.totals.total_price,
												posts.totals
													.currency_thousand_separator
											);
										if (
											response.data.price_format ==
											'%1$s&nbsp;%2$s'
										) {
											console.log('Left with space ');
											jQuery(this).text(
												posts.totals.currency_symbol +
													' ' +
													thousandSepratedVal
											);
										} else if (
											response.data.price_format ==
											'%2$s&nbsp;%1$s'
										) {
											console.log('Right with space');
											jQuery(this).text(
												thousandSepratedVal +
													' ' +
													posts.totals.currency_symbol
											);
										} else if (
											response.data.price_format ==
											'%1$s%2$s'
										) {
											console.log('Left');
											jQuery(this).text(
												posts.totals.currency_symbol +
													'' +
													thousandSepratedVal
											);
										} else if (
											response.data.price_format ==
											'%2$s%1$s'
										) {
											console.log('Right');
											jQuery(this).text(
												thousandSepratedVal +
													'' +
													posts.totals.currency_symbol
											);
										}
									}

									function addCustomSeparator(
										number,
										separator
									) {
										var numberString = number.toString();

										var parts = numberString.split('.');
										var integerPart = parts[0];
										var decimalPart =
											parts.length > 1
												? '.' + parts[1]
												: '';

										var formattedIntegerPart = '';
										for (
											var i = integerPart.length - 1,
												count = 0;
											i >= 0;
											i--
										) {
											formattedIntegerPart =
												integerPart[i] +
												formattedIntegerPart;
											count++;
											if (count % 3 === 0 && i !== 0) {
												formattedIntegerPart =
													separator +
													formattedIntegerPart;
											}
										}

										var formattedNumber =
											formattedIntegerPart + decimalPart;

										return formattedNumber;
									}

									if (isChecked == true) {
										jQuery('#main').before(
											'<div class="wc-block-components-notice-banner is-info" id="removeTaxExemptNotification"  role="alert"><div class="wc-block-components-notice-banner__content">' +
											aftax_translation_tax_exempt_notification +
												'</div></div>'
										);
										window.scrollTo(0, 0);
										var findtaxesBlocks = jQuery(
											'.wp-block-woocommerce-checkout-order-summary-taxes-block'
										);

										if (findtaxesBlocks.length > 1) {
											findtaxesBlocks.first().remove();
										}

										jQuery(
											'.wp-block-woocommerce-checkout-order-summary-taxes-block'
										).remove();
									} else {
										jQuery(
											'#removeTaxExemptNotification'
										).remove();

										var taxesBlock = jQuery(document).find(
											'.wp-block-woocommerce-checkout-order-summary-taxes-block'
										);

										if (!(taxesBlock.length > 0)) {
											jQuery(
												'.wp-block-woocommerce-checkout-order-summary-taxes-block'
											).remove();

											var innerTaxDiv =
												'<div class="wp-block-woocommerce-checkout-order-summary-taxes-block wc-block-components-totals-wrapper">';

											posts.totals.tax_lines.forEach(
												function (taxLine) {
													if (
														response.data.decimals >
														0
													) {
														var lineTaxNewValue =
															taxLine.price.slice(
																0,
																-response.data
																	.decimals
															) +
															posts.totals
																.currency_decimal_separator +
															taxLine.price.slice(
																-response.data
																	.decimals
															);

														var lineTaxthousandSepratedVal =
															addCustomSeparator(
																lineTaxNewValue,
																posts.totals
																	.currency_thousand_separator
															);

														if (
															response.data
																.price_format ==
															'%1$s&nbsp;%2$s'
														) {
															console.log(
																'Left with space '
															);
															innerTaxDiv +=
																'<div class="wc-block-components-totals-item wc-block-components-totals-taxes"><span class="wc-block-components-totals-item__label">' +
																taxLine.name +
																'</span><span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value">' +
																posts.totals
																	.currency_symbol +
																' ' +
																lineTaxthousandSepratedVal +
																'</span><div class="wc-block-components-totals-item__description"></div></div>';
														} else if (
															response.data
																.price_format ==
															'%2$s&nbsp;%1$s'
														) {
															console.log(
																'Right with space'
															);
															innerTaxDiv +=
																'<div class="wc-block-components-totals-item wc-block-components-totals-taxes"><span class="wc-block-components-totals-item__label">' +
																taxLine.name +
																'</span><span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value">' +
																lineTaxthousandSepratedVal +
																' ' +
																posts.totals
																	.currency_symbol +
																'</span><div class="wc-block-components-totals-item__description"></div></div>';
														} else if (
															response.data
																.price_format ==
															'%1$s%2$s'
														) {
															console.log('Left');
															innerTaxDiv +=
																'<div class="wc-block-components-totals-item wc-block-components-totals-taxes"><span class="wc-block-components-totals-item__label">' +
																taxLine.name +
																'</span><span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value">' +
																posts.totals
																	.currency_symbol +
																'' +
																lineTaxthousandSepratedVal +
																'</span><div class="wc-block-components-totals-item__description"></div></div>';
														} else if (
															response.data
																.price_format ==
															'%2$s%1$s'
														) {
															console.log(
																'Right'
															);
															innerTaxDiv +=
																'<div class="wc-block-components-totals-item wc-block-components-totals-taxes"><span class="wc-block-components-totals-item__label">' +
																taxLine.name +
																'</span><span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value">' +
																lineTaxthousandSepratedVal +
																'' +
																posts.totals
																	.currency_symbol +
																'</span><div class="wc-block-components-totals-item__description"></div></div>';
														}
													} else {
														var lineTaxthousandSepratedVal =
															addCustomSeparator(
																taxLine.price,
																posts.totals
																	.currency_thousand_separator
															);

														if (
															response.data
																.price_format ==
															'%1$s&nbsp;%2$s'
														) {
															console.log(
																'Left with space '
															);
															innerTaxDiv +=
																'<div class="wc-block-components-totals-item wc-block-components-totals-taxes"><span class="wc-block-components-totals-item__label">' +
																taxLine.name +
																'</span><span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value">' +
																posts.totals
																	.currency_symbol +
																' ' +
																lineTaxthousandSepratedVal +
																'</span><div class="wc-block-components-totals-item__description"></div></div>';
														} else if (
															response.data
																.price_format ==
															'%2$s&nbsp;%1$s'
														) {
															console.log(
																'Right with space'
															);
															innerTaxDiv +=
																'<div class="wc-block-components-totals-item wc-block-components-totals-taxes"><span class="wc-block-components-totals-item__label">' +
																taxLine.name +
																'</span><span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value">' +
																lineTaxthousandSepratedVal +
																' ' +
																posts.totals
																	.currency_symbol +
																'</span><div class="wc-block-components-totals-item__description"></div></div>';
														} else if (
															response.data
																.price_format ==
															'%1$s%2$s'
														) {
															console.log('Left');
															innerTaxDiv +=
																'<div class="wc-block-components-totals-item wc-block-components-totals-taxes"><span class="wc-block-components-totals-item__label">' +
																taxLine.name +
																'</span><span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value">' +
																posts.totals
																	.currency_symbol +
																'' +
																lineTaxthousandSepratedVal +
																'</span><div class="wc-block-components-totals-item__description"></div></div>';
														} else if (
															response.data
																.price_format ==
															'%2$s%1$s'
														) {
															console.log(
																'Right'
															);
															innerTaxDiv +=
																'<div class="wc-block-components-totals-item wc-block-components-totals-taxes"><span class="wc-block-components-totals-item__label">' +
																taxLine.name +
																'</span><span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value">' +
																lineTaxthousandSepratedVal +
																'' +
																posts.totals
																	.currency_symbol +
																'</span><div class="wc-block-components-totals-item__description"></div></div>';
														}
													}
												}
											);
											innerTaxDiv += '</div>';
											console.log(innerTaxDiv);

											jQuery(
												'.wp-block-woocommerce-checkout-order-summary-shipping-block'
											).after(innerTaxDiv);
										} else {
											jQuery(
												'.wp-block-woocommerce-checkout-order-summary-taxes-block'
											).show();
										}
									}
								}
							);
						});
				}
			},
			error: function (error) {},
		});
	};

	useEffect(() => {
		setExtensionData(
			'af_vat_tax_exempt_block',
			'addifyIsTaxExemptChecked',
			taxExemptCheckboxIsChecked
		);
	}, [setExtensionData, taxExemptCheckboxIsChecked]);

	return (
		<fieldset
			className="wc-block-components-checkout-step wc-block-components-checkout-step--with-step-number wp-block-af_vat_tax_exempt_block-tax-exempt"
			style={{ display: 'none' }}
		>
			<div class="wc-block-components-checkout-step__heading">
				<h2
					class="wc-block-components-title wc-block-components-checkout-step__title"
					aria-hidden="true"
				>
					{aftax_translation_tax_exempt_heading}
				</h2>
			</div>
			<div className="taxExemptInnerDiv">
				<input
					className="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox wc-block-components-checkout-step__container"
					id="tax_exemption_checkbox"
					type="checkbox"
					name="tax_exemption_checkbox"
					onChange={handleCheckboxChange}
				/>
				<span>
					{' '}
					{aftax_translation_tax_exempt_message}
					{' '}
				</span>
			</div>
		</fieldset>
	);
};
