const path = require('path');
const defaultConfig = require('@wordpress/scripts/config/webpack.config');
const WooCommerceDependencyExtractionWebpackPlugin = require('@woocommerce/dependency-extraction-webpack-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');

module.exports = {
	...defaultConfig,
	entry: {
		index: path.resolve(process.cwd(), 'src', 'js', 'index.js'),
		'af-tax-exempt-block': path.resolve(
			process.cwd(),
			'src',
			'js',
			'af-tax-exempt-block',
			'index.js'
		),
		'af-tax-exempt-block-frontend': path.resolve(
			process.cwd(),
			'src',
			'js',
			'af-tax-exempt-block',
			'frontend.js'
		),
	},
	plugins: [
		...defaultConfig.plugins.filter(
			(plugin) =>
				plugin.constructor.name !== 'DependencyExtractionWebpackPlugin'
		),
		new WooCommerceDependencyExtractionWebpackPlugin(),
		new MiniCssExtractPlugin({
			filename: `[name].css`,
		}),
	],
};
